// Logon.cpp : implementation file
//

#include "stdafx.h"
#include "NetDecoder.h"
#include "Logon.h"
#include "Include/CommonFun.h"
//#include"DecCtrlClient.h"
// CLogon dialog

IMPLEMENT_DYNAMIC(CLogon, CDialog)

CLogon::CLogon(CWnd* pParent /*=NULL*/)
	: CDialog(CLogon::IDD, pParent)
{
	m_ptDecoder = NULL;
}

CLogon::~CLogon()
{
}

void CLogon::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Control(pDX,IDC_CHECK_STAY_PASSWORD,m_btnStayPwd);
	DDX_Control(pDX,IDC_COMBO_USERNAME,m_cboUser);
}

BEGIN_MESSAGE_MAP(CLogon, CDialog)
	ON_BN_CLICKED(IDC_BUTTON_LOGON_OK, &CLogon::OnBnClickedButtonLogon)
	ON_BN_CLICKED(IDC_BUTTON_LOGON_CANCEL, &CLogon::OnBnClickedButtonLogoncancel)
END_MESSAGE_MAP()

void CLogon::Init( st_Decoder* _ptDecoder )
{
	m_ptDecoder = _ptDecoder;
}

// CLogon message handlers

BOOL CLogon::OnInitDialog()
{
	CDialog::OnInitDialog();

	SetWindowText(GetText(IDS_MAIN_LOGON));
	SetDlgItemText(IDC_STATIC_USERNAME,GetText(IDS_MAIN_USERNAME)+GetText(IDS_MAIN_COLON));
	SetDlgItemText(IDC_STATIC_PASSWORD,GetText(IDS_MAIN_PASSWORD)+GetText(IDS_MAIN_COLON));
	SetDlgItemText(IDC_CHECK_STAY_PASSWORD,GetText(IDS_MAIN_STAY_PASSWORD));
	SetDlgItemText(IDC_BUTTON_LOGON_OK,GetText(IDS_NVS_INFO_OK));
	SetDlgItemText(IDC_BUTTON_LOGON_CANCEL,GetText(IDS_NVS_INFO_CANCEL));

	m_cboUser.AddString(_T("Admin"));
	m_cboUser.AddString(_T("admin"));
	m_cboUser.AddString(_T("DEC"));
	m_btnStayPwd.SetCheck(m_ptDecoder->m_bStayPass);
	if (m_ptDecoder->m_bStayPass)
	{
		int iUser = m_cboUser.FindStringExact(0,m_ptDecoder->m_astrUser);
		if (iUser < 0)
		{
			iUser = 0;
		}
		m_cboUser.SetCurSel(iUser);
		SetDlgItemText(IDC_EDIT_PWD,m_ptDecoder->m_astrPass);
	}
	else
	{
		m_cboUser.SetCurSel(0);
	}

	return TRUE;  
}

void CLogon::OnBnClickedButtonLogon()
{
	CString strPwd;
	GetDlgItemText(IDC_EDIT_PWD,strPwd);
	if (strPwd.IsEmpty())
	{
		MessageBox(GetText(IDS_MAIN_PWD_EMPTY),_T(""),MB_OK|MB_TOPMOST);
		return;
	}

	CString strUser;
	GetDlgItemText(IDC_COMBO_USERNAME, strUser);
	if (strUser.IsEmpty())
	{
		MessageBox(GetText(IDS_STRING_USERNAME_EMPTY), _T(""), MB_OK|MB_TOPMOST);
		return;
	}
	
	m_ptDecoder->m_astrUser = strUser;
	m_ptDecoder->m_astrPass = strPwd;
	m_ptDecoder->m_bStayPass = m_btnStayPwd.GetCheck();
	OnOK();
}

void CLogon::OnBnClickedButtonLogoncancel()
{
	OnCancel();
}
